// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.util;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Map;

public class SupportedFormats
{
    private Map supportedFormatsMap;
    
    public SupportedFormats(final Properties properties) {
        this.supportedFormatsMap = new HashMap();
        final String propertyPrefix = "SupportedFormats.";
        final Enumeration enum1 = properties.propertyNames();
        while (enum1.hasMoreElements()) {
            final String propertyName = enum1.nextElement();
            if (propertyName.startsWith(propertyPrefix)) {
                final String schemaLabel = propertyName.substring(propertyPrefix.length());
                final String schemaLocation = (String)properties.get(propertyName);
                this.supportedFormatsMap.put(schemaLocation, schemaLabel);
            }
        }
        if (this.supportedFormatsMap.size() == 0) {
            System.err.println("SupportedFormats entries are missing from properties file");
        }
    }
    
    public String getMetadataPrefix(final String namespaceURI, final String schemaURL) {
        return this.supportedFormatsMap.get(namespaceURI + " " + schemaURL);
    }
    
    public String getSchemaURL(final String metadataPrefix) {
        final String schemaLocation = this.getSchemaLocation(metadataPrefix);
        final StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }
    
    public String getNamespaceURI(final String metadataPrefix) {
        final String schemaLocation = this.getSchemaLocation(metadataPrefix);
        final StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        return tokenizer.nextToken();
    }
    
    public String getSchemaLocation(final String metadataPrefix) {
        for (final Map.Entry entry : this.supportedFormatsMap.entrySet()) {
            final String value = entry.getValue();
            if (value.equals(metadataPrefix)) {
                return entry.getKey();
            }
        }
        return null;
    }
    
    public boolean containsValue(final String metadataPrefix) {
        return this.supportedFormatsMap.containsValue(metadataPrefix);
    }
    
    public Iterator iterator() {
        return this.supportedFormatsMap.entrySet().iterator();
    }
}
